"""Miscellaneous helper functions including timezone handling."""

from datetime import datetime, date, time
from zoneinfo import ZoneInfo
from typing import Optional


def now_in_timezone(tz_name: str = "Asia/Kolkata") -> datetime:
    """Return the current datetime in the specified timezone."""
    return datetime.now(ZoneInfo(tz_name))


def to_local_date_str(dt: date) -> str:
    """Convert a date object to ISO string.  Provided for completeness."""
    return dt.isoformat()


def parse_date(date_str: str) -> date:
    """Parse an ISO formatted date string into a date object."""
    return date.fromisoformat(date_str)